﻿


using Android.Content;
using Android.Graphics;
using Android.Media;
using Android.Views;
using Android.Webkit;

using System.Diagnostics;
using System.Net;
using System.Runtime.InteropServices;
using System.Timers;

using static Android.Views.ViewGroup;
using Color = Android.Graphics.Color;
using Encoding = System.Text.Encoding;
using Orientation = Android.Widget.Orientation;
using String = System.String;


using Rect = Android.Graphics.Rect;
using View = Android.Views.View;
using WebView = Android.Webkit.WebView;
using Button = Android.Widget.Button;
using ListView = Android.Widget.ListView;
using Plugin.FilePicker;
using Android.Content.PM;
using System.Text;
using System.Collections.Concurrent;
using Android.Telecom;








namespace Glukalka3
{
    class global
    {
        [DllImport("emulate1", EntryPoint = "Get_VM")]
        unsafe static extern int* Get_VM();

        [DllImport("emulate1", EntryPoint = "Get_FN")]
        unsafe static extern byte * Get_FN();

        [DllImport("emulate1", EntryPoint = "Get_SB")]
        unsafe static extern int * Get_SB();

        [DllImport("emulate1", EntryPoint = "init")]
        unsafe static extern void init();

        [DllImport("emulate1", EntryPoint = "step")]
        unsafe static extern void step();

        [DllImport("emulate1", EntryPoint = "key")]
        unsafe static extern void key(int filename);

        [DllImport("emulate1", EntryPoint = "F_open")]
        unsafe static extern void F_open();

        [DllImport("emulate1", EntryPoint = "Border")]
        unsafe static extern byte Border();

        [DllImport("emulate1", EntryPoint = "save")]
        unsafe static extern void save();

        [DllImport("emulate1", EntryPoint = "reset")]
        unsafe static extern void reset();

        [DllImport("emulate1", EntryPoint = "GetTapeTraps")]
        unsafe static extern int GetTapeTraps();

        [DllImport("emulate1", EntryPoint = "SetTapeTraps")]
        unsafe static extern void SetTapeTraps(int tt);

        [DllImport("emulate1", EntryPoint = "SaveSettings")]
        unsafe static extern void SaveSettings();

        [DllImport("emulate1", EntryPoint = "GetJOY1")]
        unsafe static extern int GetJOY1();

        [DllImport("emulate1", EntryPoint = "SetJOY1")]
        unsafe static extern void SetJOY1(int type);

        [DllImport("emulate1", EntryPoint = "GetMode1")]
        unsafe static extern int GetMode1();

        [DllImport("emulate1", EntryPoint = "SetMode1")]
        unsafe static extern void SetMode1(int mode);

        [DllImport("emulate1", EntryPoint = "Get_stereo")]
        unsafe static extern int Get_stereo();

        [DllImport("emulate1", EntryPoint = "Set_stereo")]
        unsafe static extern void Set_stereo(int arg);

        [DllImport("emulate1", EntryPoint = "Gett")]
        unsafe static extern int Gett();

        [DllImport("emulate1", EntryPoint = "sethomedir")]
        unsafe static extern void sethomedir();

        [DllImport("emulate1", EntryPoint = "gethomedir")]
        unsafe static extern byte * gethomedir();

        [DllImport("emulate1", EntryPoint = "DumpPSG1")]
        unsafe static extern void DumpPSG1(int begin);

        [DllImport("emulate1", EntryPoint = "SetDisk")]
        unsafe static extern void SetDisk(int n);

        [DllImport("emulate1", EntryPoint = "GetDisk")]
        unsafe static extern byte * GetDisk(int n);

        [DllImport("emulate1", EntryPoint = "F_open_full")]
        unsafe static extern void F_open_full();

        [DllImport("emulate1", EntryPoint = "NMI")]
        unsafe static extern void NMI();


        public static unsafe int* vmem = null;
        public static unsafe byte* fn = null;

        //Sound buffer
        public static unsafe int * au = null;

    



        //DIR
        public static byte[] b;
        public static string s;


        public static int pause = 0;
        public static int run_emu = 0;
        public static bool fast_tape = false;
        public static bool sound = true;

        public static string current_file = null;

        public static int dump = 0;

        public static unsafe string GetHOMEDIR()
        {
            byte* BB;
            string s, ss;
            byte[] bb;

            BB = gethomedir();
            bb = new byte[400];


            int i = 0;

            while (BB[i] != 0)
            {
                bb[i] = BB[i];
                i++;
            }

            s = Encoding.UTF8.GetString(bb);
            ss = s.Substring(0, i);

            return ss;
        }

        public static unsafe string GetDiskB()
        {
            byte* BB;
            string s, ss;
            byte[] bb;

            BB = GetDisk(1);
            bb = new byte[400];


            int i = 0;

            while (BB[i] != 0)
            {
                bb[i] = BB[i];
                i++;
            }

            s = Encoding.UTF8.GetString(bb);
            ss = s.Substring(0, i);

            return ss;
        }

        public static unsafe void SetDiskB(string dir)
        {
            byte[] B;
            B = Encoding.UTF8.GetBytes(dir);

            int len = B.Length;

            for (int i = 0; i < B.Length; i++)
                fn[i] = B[i];

            fn[len] = 0;

            SetDisk (1);
        }

        public static unsafe void DumpPSG2(string dir, int begin)
        {
            if (dir != null)
            {
                byte[] B;
                B = Encoding.UTF8.GetBytes(dir);

                int len = B.Length;

                for (int i = 0; i < B.Length; i++)
                    fn[i] = B[i];

                fn[len] = 0;
            }

            DumpPSG1(begin);
        }

        public static unsafe void SetHOMEDIR(string dir)
        {
            byte[] B;
            B = Encoding.UTF8.GetBytes(dir);

            int len = B.Length;

            for (int i = 0; i < B.Length; i++)
                fn[i] = B[i];

            fn[len] = 0;

            sethomedir();
        }

        public static unsafe bool GetTapeTraps_()
        {
            int i = GetTapeTraps();

            if (i == 0)
                return false;

            return true;
        }

        public static unsafe void SetTapeTraps_(bool tt)
        {
            int i;

            if (tt)
                i = 1;
            else
                i = 0;

            SetTapeTraps(i);
        }

        public static unsafe void SaveSettings_()
        {
            SaveSettings();
        }

        public static unsafe void nmi()
        {
            NMI();
        }

        public static unsafe void Init()
        {
            vmem = Get_VM();
            fn = Get_FN();
            au = Get_SB();

            for (int i = 0; i < b.Length; i++)
                fn[i] = b[i];

            fn[b.Length] = 0;

            init();
        }

        public static void Step()
        {
            step();
        }

        public static void Key(int k)
        {
            key(k);
        }

        public static byte GetBorder()
        {
            return Border();
        }

        public static unsafe void FOPEN()
        {
            for (int i = 0; i < b.Length; i++)
                fn[i] = b[i];

            fn[b.Length] = 0;

            F_open();
        }

        public static unsafe void FOPENFP()
        {
            for (int i = 0; i < b.Length; i++)
                fn[i] = b[i];

            fn[b.Length] = 0;

            F_open_full();
        }

        public static unsafe void SAVE()
        {
            string ffn = current_file + ".z80";

            byte[] B;
            B = Encoding.UTF8.GetBytes(ffn);

            int len = B.Length;

            for (int i = 0; i < B.Length; i++)
                fn[i] = B[i];

            fn[len] = 0;

            save();
        }

        public static void RESET()
        {
            reset();
        }

        public static int GetMode2()
        {
            return GetMode1();
        }

        public static int JOY2()
        {
            return GetJOY1();
        }

        public static void SetMode2(int m)
        {
            SetMode1(m);
        }

        public static void SetJOY2(int j)
        {
            SetJOY1(j);
        }

        public static int GetStereo()
        {
            return Get_stereo();
        }

        public static void SetStereo(int a)
        {
            Set_stereo(a);
        }

        public static int GetSQT()
        {
            return Gett();
        }
    }







    public class MyView : View
    {
        private static System.Timers.Timer aTimer;
        static int count = 0;

        Bitmap bitmap;
        int[] videomemory;
        Rect r1;
        Rect r2;

        int draw_counter = 0;

        Canvas canva;
        Paint paint;

        ConcurrentQueue<int> q;
    

        public MyView(Context? context) : base(context)
        {            
            bitmap = Bitmap.CreateBitmap(320, 240, Bitmap.Config.Rgb565);
            canva = new Canvas(bitmap);
            paint = new Paint();
            paint.TextSize = 30;
            paint.Color = Color.Brown;
            videomemory = new int[320 * 240];
            r1 = new Rect(0, 0, 320, 240);
            r2 = new Rect();

        
            aTimer = new System.Timers.Timer(20);
            aTimer.Elapsed += OnTimedEvent;
            aTimer.AutoReset = true;
            aTimer.Enabled = true;
            aTimer.Start();

            q = new ConcurrentQueue<int>();

            Thread t2 = new Thread(delegate ()
            {
                byte[] sb = new byte[882 * 4];

                AudioTrack audioTrack;

                audioTrack = new AudioTrack(
 // Stream type
 Android.Media.Stream.Music,
 // Frequency
 44100,
 // Mono or stereo
 ChannelOut.Stereo,
 // Audio encoding
 Android.Media.Encoding.Pcm16bit,
 // Length of the audio clip.
 882 * 4,
 // Mode. Stream or static.
 AudioTrackMode.Stream);

                audioTrack.Play();

                while (true)
                {
                    if (q.Count >= 882)
                    {
                        for (int i = 0; i < 882; i++)
                        {
                            int item;
                            q.TryDequeue(out item);

                            sb[i * 4 + 0] = (byte)(item & 255);
                            sb[i * 4 + 1] = (byte)((item & 0xFF00) / 256);
                            sb[i * 4 + 2] = (byte)((item & 0xFF0000) / 65536);
                            sb[i * 4 + 3] = (byte)((item & 0xFF000000) / (65536 * 256));
                        }
                    }

                    if ((global.sound == true) && (global.pause == 0))
                        audioTrack.Write(sb, 0, 882 * 4);

                    Thread.Sleep(10);
                }
            });
            t2.Start();
        }




        int paused = 0;
     
        unsafe private void OnTimedEvent(System.Object source, ElapsedEventArgs e)
        {
            if (global.pause == 1)
            {
                if (paused > 0)
                    Invalidate();

                paused = 0;

                return;
            }

            paused++;
            count++;

            Invalidate();
        }

        int width, height;

        long ms()
        {
            return (DateTime.Now.Ticks / TimeSpan.TicksPerMillisecond);
        }


        
        unsafe protected override void OnDraw(Canvas canvas)
        {
            base.OnDraw(canvas);

            if (count == 0)
                return;



            //////*** CALL C*////

            //aTimer.Stop();

            long start = ms();

            if (global.pause != 1)
            {
                if ((global.run_emu == 1) || ((global.GetSQT() == 2) && global.fast_tape))
                {
                    long start1 = ms();

                    while ((ms() - start1) < 15)
                        global.Step();
                }
                else
                    global.Step();
            }

            for (int y = 0; y < 240; y++)
            {
                for (int x = 0; x < 320; x++)
                {
                    videomemory[x + y * 320] = global.vmem[x * 2 + (y * 640 * 2)];
                }
            }


            for (int i = 0; i < 882; i++)     
                q.Enqueue(global.au[i]);
           


            ////// *** UPDATE




            if (draw_counter == 0)
            {
                width = canvas.Width;
                height = canvas.Height;

                r2 = new Rect(0, 0, width, height);
            }

            bitmap.SetPixels(videomemory, 0, 320, 0, 0, 320, 240);

            

           
            if (global.pause == 1)
                canva.DrawText("PAUSE", 100, 120, paint);

            if (global.run_emu == 1)
                canva.DrawText("TURBO", 100, 120, paint);

            if ((global.GetSQT() == 2) && global.fast_tape)
                canva.DrawText("FAST_TAPE", 80, 120, paint);


          
            canvas.DrawBitmap(bitmap, r1, r2, null);

            

           
            draw_counter++;


            long end = ms();

            long time = 20 - (end - start);
            if (time<1)
                time  = 1;


           
        }
    }

    public class HelloWebViewClient : WebViewClient
    {
        public override bool ShouldOverrideUrlLoading(WebView view, string url)
        {
            view.LoadUrl(url);
            return false;
        }
    }


    public class CustomDownloadListener : Java.Lang.Object, IDownloadListener
    {
        string rv;

        string Clear(string arg)
        {
            rv = "";

            for (int i = 0; i < arg.Length; i++)
            {
                if (arg[i] == '%' && arg[i + 1] == '2' && arg[i + 2] == '0')
                {
                    rv += " ";
                    i += 2;
                }
                else
                    rv += arg[i];
            }

            return rv;
        }

        public void OnDownloadStart(string url, string userAgent, string contentDisposition, string mimetype, long contentLength)
        {
            string destination = Clear(global.s + "/" + System.IO.Path.GetFileName(url));

            using (WebClient wc = new WebClient())
            {
                wc.DownloadFileCompleted += Wc_DownloadFileCompleted;
                //wc.DownloadProgressChanged += wc_DownloadProgressChanged;
                wc.DownloadFileAsync(
                    // Param1 = Link of file
                    new System.Uri(url),
                    // Param2 = Path to save
                    destination
                );
            }
        }

        private void Wc_DownloadFileCompleted(object? sender, System.ComponentModel.AsyncCompletedEventArgs e)
        {
            //NotificationCenter.Current.Show("Download complete");
        }
    }


    [Activity(Label = "@string/app_name", LaunchMode = LaunchMode.SingleTop, MainLauncher = true, ConfigurationChanges = ConfigChanges.ScreenSize | ConfigChanges.Orientation, ScreenOrientation = ScreenOrientation.Portrait)]
    [IntentFilter(new[] { Android.Content.Intent.ActionView, Android.Content.Intent.ActionEdit }, Categories = new[] { Android.Content.Intent.CategoryDefault }, DataMimeType = "application/octet-stream", DataHost = "*", DataPathPattern = ".*\\.SCL")]
    [IntentFilter(new[] { Android.Content.Intent.ActionView, Android.Content.Intent.ActionEdit }, Categories = new[] { Android.Content.Intent.CategoryDefault }, DataMimeType = "application/octet-stream", DataHost = "*", DataPathPattern = ".*\\.TRD")]
    [IntentFilter(new[] { Android.Content.Intent.ActionView, Android.Content.Intent.ActionEdit }, Categories = new[] { Android.Content.Intent.CategoryDefault }, DataMimeType = "application/octet-stream", DataHost = "*", DataPathPattern = ".*\\.TZX")]
    [IntentFilter(new[] { Android.Content.Intent.ActionView, Android.Content.Intent.ActionEdit }, Categories = new[] { Android.Content.Intent.CategoryDefault }, DataMimeType = "application/octet-stream", DataHost = "*", DataPathPattern = ".*\\.TAP")]
    [IntentFilter(new[] { Android.Content.Intent.ActionView, Android.Content.Intent.ActionEdit }, Categories = new[] { Android.Content.Intent.CategoryDefault }, DataMimeType = "application/octet-stream", DataHost = "*", DataPathPattern = ".*\\.FDI")]
    [IntentFilter(new[] { Android.Content.Intent.ActionView, Android.Content.Intent.ActionEdit }, Categories = new[] { Android.Content.Intent.CategoryDefault }, DataMimeType = "application/octet-stream", DataHost = "*", DataPathPattern = ".*\\.Z80")]
    [IntentFilter(new[] { Android.Content.Intent.ActionView, Android.Content.Intent.ActionEdit }, Categories = new[] { Android.Content.Intent.CategoryDefault }, DataMimeType = "application/octet-stream", DataHost = "*", DataPathPattern = ".*\\.SNA")]

    public class MainActivity : Android.App.Activity
    {

        private void OkAction(object sender, DialogClickEventArgs e)
        {
            var myButton = sender as Button;
            if (myButton != null)
            {

            }
        }

        private async void openweb(object sender, EventArgs e)
        {
            global.pause = 1;
            SetContentView(mLinearLayout3);
        }

        private bool disk_file(string s)
        {
            if (String.Equals(s, ".trd",
                   StringComparison.OrdinalIgnoreCase))
                return true;

            if (String.Equals(s, ".fdi",
                    StringComparison.OrdinalIgnoreCase))
                return true;

            return false;
        }

        private bool zip_file(string s)
        {
            if (String.Equals(s, ".zip",
                StringComparison.OrdinalIgnoreCase))
                return true;

            return false;
        }
      
        private bool my_file(string s)
        {
            if (String.Equals(s, ".zip",
                StringComparison.OrdinalIgnoreCase))
                return true;

            if (String.Equals(s, ".z80",
                    StringComparison.OrdinalIgnoreCase))
                return true;

            if (String.Equals(s, ".sna",
                    StringComparison.OrdinalIgnoreCase))
                return true;

            if (String.Equals(s, ".trd",
                    StringComparison.OrdinalIgnoreCase))
                return true;

            if (String.Equals(s, ".fdi",
                    StringComparison.OrdinalIgnoreCase))
                return true;

            if (String.Equals(s, ".scl",
                    StringComparison.OrdinalIgnoreCase))
                return true;

            if (String.Equals(s, ".tap",
                    StringComparison.OrdinalIgnoreCase))
                return true;

            if (String.Equals(s, ".tzx",
                    StringComparison.OrdinalIgnoreCase))
                return true;

            if (String.Equals(s, ".wav",
                    StringComparison.OrdinalIgnoreCase))
                return true;

            return false;
        }


        int BC_first = 0;
        int BC_first1 = 0;

        private async void Button_Clicked(object sender, EventArgs e)
        {

            global.pause = 1;

            DirectoryInfo d = new DirectoryInfo(global.s);

            FileInfo[] Files = d.GetFiles("*");

            int nfiles = 0;

            string[] items = new string[] { };

            foreach (FileInfo file in Files)
            {
                if (my_file(file.Extension))
                {
                    nfiles++;
                    items = items.Append(file.Name).ToArray();
                }
            }

            ArrayAdapter ListAdapter = new ArrayAdapter<String>(this, Android.Resource.Layout.SimpleListItem1, items);
            lw.Adapter = ListAdapter;

            if (nfiles == 0)
            {
                using (var builder = new AlertDialog.Builder(this))
                {
                    var title = "No Files. You have to download files from the Web (button near).";
                    builder.SetTitle(title);
                    builder.SetPositiveButton("OK", OkAction);
                    var myCustomDialog = builder.Create();

                    myCustomDialog.Show();
                }
            }

            if (BC_first == 0)
            {
                lw.ItemLongClick += (object? sender, AdapterView.ItemLongClickEventArgs e) =>
                 {
                     string selectedFromList = lw.GetItemAtPosition(e.Position).ToString();
                     filename = global.s + "/" + selectedFromList;

                     using (var builder = new AlertDialog.Builder(this))
                     {
                         var title = "Are you sure to delete " + selectedFromList + " ?";
                         builder.SetTitle(title);
                         builder.SetPositiveButton("OK", OkAction2);
                         builder.SetNegativeButton("Cancel", CancelAction);
                         var myCustomDialog = builder.Create();

                         myCustomDialog.Show();
                     }
                 };

                lw.ItemClick += (object sender, Android.Widget.AdapterView.ItemClickEventArgs e) =>
                {
                    string selectedFromList = lw.GetItemAtPosition(e.Position).ToString();


                    FileInfo file = new FileInfo(selectedFromList);



                    if (zip_file(file.Extension))
                    {
                        System.IO.Compression.ZipFile.ExtractToDirectory(global.s + "/" + selectedFromList, global.s);
                        Toast.MakeText(this, selectedFromList + "unzipped.",
                            Android.Widget.ToastLength.Short).Show();

                        Button_Clicked(null, null);
                    }
                    else
                    {                       
                        global.current_file = selectedFromList.Split(".")[0];
                        global.b = System.Text.Encoding.UTF8.GetBytes(selectedFromList);
                        global.FOPEN();

                        global.pause = 0;
                        SetContentView(mLinearLayout1);
                    }


                };

                BC_first = 1;
            }


            SetContentView(mLinearLayout2);
        }

        string filename;
        private void OkAction2(object sender, DialogClickEventArgs e)
        {
            FileInfo file = new FileInfo(filename);
            file.Delete();

            Button_Clicked(null, null);
        }


        private async void zurueck(object sender, EventArgs e)
        {
            global.pause = 0;
            SetContentView(mLinearLayout1);
        }

        private async void zurueck1(object sender, EventArgs e)
        {
            SetContentView(mLinearLayout4);
        }

        LinearLayout mLinearLayout1, mLinearLayout2, mLinearLayout3, mLinearLayout4, mLinearLayout21;
        ListView lw, lw1;
        EditText e;
        WebView wv;


        protected override void OnPause()
        {
            base.OnPause();
            global.pause = 1;

            if (global.pause == 0)
                bpause.SetImageResource(Resource.Drawable.pause);
            else
                bpause.SetImageResource(Resource.Drawable.play);

        }


        protected override void OnResume()
        {
            base.OnResume();
            global.pause = 0;

            if (global.pause == 0)
                bpause.SetImageResource(Resource.Drawable.pause);
            else
                bpause.SetImageResource(Resource.Drawable.play);
        }


        private async void go(object sender, EventArgs eeee)
        {
            string url;

            url = e.Text;

            wv.LoadUrl(url);
        }

        private async void p_ause(object sender, EventArgs eeee)
        {
            global.pause = 1 - global.pause;
            global.run_emu = 0;

            if (global.pause == 0)
                bpause.SetImageResource(Resource.Drawable.pause);
            else
                bpause.SetImageResource(Resource.Drawable.play);
        }


        private async void run(object sender, EventArgs eeee)
        {
            global.run_emu = 1 - global.run_emu;
            global.pause = 0;

            if (global.pause == 0)
                bpause.SetImageResource(Resource.Drawable.pause);
            else
                bpause.SetImageResource(Resource.Drawable.play);
        }

        EditText EditText1;

        private void OkActionP(object sender, DialogClickEventArgs e)
        {
            global.pause = 0;
        }

       
        private void OkListener(object sender, EventArgs eeee)
        {
            global.current_file = EditText1.Text;

            global.SAVE();

            Toast.MakeText(this, global.current_file + ".z80 is saved.",
              Android.Widget.ToastLength.Short).Show();

            global.pause = 0;
        }

        private async void Save(object sender, EventArgs eeee)
        {
            global.pause = 1;

            if (global.current_file == null)
            {
                using (var builder = new AlertDialog.Builder(this))
                {
                    var title = "No current file. You have to download files from the Web (button near).";
                    builder.SetTitle(title);
                    builder.SetPositiveButton("OK", OkActionP);
                    var myCustomDialog = builder.Create();

                    myCustomDialog.Show();
                }
            }
            else
            {
                EditText1 = new EditText(this);
                EditText1.Text = global.current_file;
                var ConfirmButton = new Button(this);
                var ad = (new AlertDialog.Builder(this)).Create();
                ad.SetTitle("Save as...");
                ad.SetView(EditText1); // <----
                ad.SetButton("Confirm", OkListener);
                ad.SetButton2("Cancel", OkActionP);
                ad.SetCancelable(false);
                ad.Show();
            }
        }

        private void OkAction1(object sender, DialogClickEventArgs e)
        {
            global.RESET();
        }
        private void CancelAction(object sender, DialogClickEventArgs e)
        {
        }

        private async void reset(object sender, EventArgs eeee)
        {
            using (var builder = new AlertDialog.Builder(this))
            {
                var title = "Reset ?";
                builder.SetTitle(title);
                builder.SetPositiveButton("OK", OkAction1);
                builder.SetNegativeButton("Cancel", CancelAction);
                var myCustomDialog = builder.Create();

                myCustomDialog.Show();
            }
        }

        private async void Settings(object sender, EventArgs eeee)
        {
            global.pause = 1;
            spinner2.SetSelection(global.GetMode2());
            SetContentView(mLinearLayout4);
        }

        private async void about(object sender, EventArgs eeee)
        {
            var clipboardManager = (ClipboardManager)this.GetSystemService(Context.ClipboardService);

            ClipData clip = ClipData.NewPlainText("Android Clipboard", "43MbSqKJUa34kVqg45FwU9JeN8SremHvJ125CaTi3q8rASQ6bvk2bafNb9p5eJR5KqQ3cJjcLnQZGa88B2SHfBHxQfYAJ96");

            clipboardManager.PrimaryClip = clip;


            TextView tview = new TextView(this);
            tview.Text = "      Dmitry Sanarin\n      dmitry@sanarin.ru  \n      (XMR address copied to clipboard)";

            new AlertDialog.Builder(this)
              .SetIcon(Android.Resource.Drawable.IcDialogDialer)
              .SetPositiveButton("Yes", (sender, args) =>
              {
                  //Do somthing  
              })
              .SetCustomTitle(tview)
              .Show();
        }

        ImageButton bpause;
        Spinner spinner2;
        TextView Diiir, Diiir1;


        private void OkListener2(object sender, EventArgs eeee)
        {
            string s = EditText1.Text;
            global.DumpPSG2(s + ".psg", 1);
            global.dump = 1;

            Toast.MakeText(this, s + " Dump is started.",
            Android.Widget.ToastLength.Short).Show();

            global.pause = 0;
        }

        private async void dump_s(object sender, EventArgs eeee)
        {


            if (global.dump == 1)
            {
                global.DumpPSG2(null, 0);
                global.dump = 0;

                Toast.MakeText(this, "Dump is stopped.",
              Android.Widget.ToastLength.Short).Show();

            }
            else
            {
                global.pause = 1;

                EditText1 = new EditText(this);
                EditText1.Text = "sound_dump";
                var ConfirmButton = new Button(this);
                var ad = (new AlertDialog.Builder(this)).Create();
                ad.SetTitle("Dump as...");
                ad.SetView(EditText1); // <----
                ad.SetButton("Confirm", OkListener2);
                ad.SetButton2("Cancel", OkActionP);
                ad.SetCancelable(false);
                ad.Show();
            }
        }

        private async void SD(object sender, EventArgs eeee)
        {
            var file = await CrossFilePicker.Current.PickFile();

            if (file != null)
            {
                string Text = file.FilePath;
                FileInfo f = new FileInfo(Text);

                string fp = Text.Split("/")[1];

                if (fp == "storage")
                {
                    global.s = f.Directory.FullName;
                    Diiir.Text = global.s;
                    global.SetHOMEDIR(global.s);
                    global.SaveSettings_();
                }
                else
                {
                    using (var builder = new AlertDialog.Builder(this))
                    {
                        var title = "Can't select this directory. Use internal storage.";
                        builder.SetTitle(title);
                        builder.SetPositiveButton("OK", OkAction);
                        var myCustomDialog = builder.Create();

                        myCustomDialog.Show();
                    }
                }
            }
        }

        private async void SD1(object sender, EventArgs eeee)
        {
            DirectoryInfo d = new DirectoryInfo(global.s);

            FileInfo[] Files = d.GetFiles("*");

            int nfiles = 0;

            string[] items = new string[] { };

            foreach (FileInfo file in Files)
            {
                if (disk_file(file.Extension))
                {
                    nfiles++;
                    items = items.Append(file.Name).ToArray();
                }
            }

            ArrayAdapter ListAdapter = new ArrayAdapter<String>(this, Android.Resource.Layout.SimpleListItem1, items);
            lw1.Adapter = ListAdapter;

            if (nfiles == 0)
            {
                using (var builder = new AlertDialog.Builder(this))
                {
                    var title = "No Files. You have to download files from the Web (button near).";
                    builder.SetTitle(title);
                    builder.SetPositiveButton("OK", OkAction);
                    var myCustomDialog = builder.Create();

                    myCustomDialog.Show();
                }
            }

            if (BC_first1 == 0)
            {               
                lw1.ItemClick += (object sender, Android.Widget.AdapterView.ItemClickEventArgs e) =>
                {
                    string selectedFromList = lw1.GetItemAtPosition(e.Position).ToString();                                   

                    Diiir1.Text = selectedFromList;

                    global.SetDiskB(selectedFromList);
                    global.SaveSettings_();

                    SetContentView(mLinearLayout4);
                };

                BC_first1 = 1;
            }


            SetContentView(mLinearLayout21);


        }


        private async void SDD(object sender, EventArgs eeee)
        {
            global.s = FilesDir.ToString();
            Diiir.Text = global.s;
            global.SetHOMEDIR(global.s);
            global.SaveSettings_();
        }


        private async void NmI (object sender, EventArgs eeee)
        {
            global.nmi();
        }



        int animatekeys = 0;

        protected override void OnCreate(Bundle? savedInstanceState)
        {
            base.OnCreate(savedInstanceState);


            int ScreenWidth = Resources.DisplayMetrics.WidthPixels; /// Resources.DisplayMetrics.Density);
            int ScreenHeight = Resources.DisplayMetrics.HeightPixels;



            global.s = FilesDir.ToString();
            global.b = Encoding.UTF8.GetBytes(global.s);
            global.Init();


            global.s = global.GetHOMEDIR();
           


            //////////////////// LAYOUT 4 /////////////////////////////

            mLinearLayout4 = new LinearLayout(this);
            mLinearLayout4.Orientation = Orientation.Vertical;

            TextView t1 = new TextView(this);
            t1.SetTextColor(Color.Blue);            
            t1.Text = "Tape";
            mLinearLayout4.AddView(t1);


            LinearLayout mLinearLayout44 = new LinearLayout(this);
            mLinearLayout44.Orientation = Orientation.Horizontal;


            CheckBox checkBox1 = new CheckBox(this);
            checkBox1.Text = "Fast Tape";
            checkBox1.Checked = global.fast_tape;
            checkBox1.CheckedChange += (sender, e) =>
            {
                global.fast_tape = e.IsChecked;
            };

            mLinearLayout44.AddView(checkBox1);

            CheckBox checkBox = new CheckBox(this);
            checkBox.Checked = global.GetTapeTraps_();
            checkBox.Text = "Tape Traps";
            checkBox.CheckedChange += (sender, e) =>
            {
                global.SetTapeTraps_(e.IsChecked);
                global.SaveSettings_();
            };

            mLinearLayout44.AddView(checkBox);

            mLinearLayout4.AddView(mLinearLayout44);

            TextView t2 = new TextView(this);
            t2.SetTextColor(Color.Blue);
            t2.Text = "Joystick";
            mLinearLayout4.AddView(t2);


            var items = new List<string>() { "Kempston joystick", "Sinclair joystick", "Cursor joystick", "OPQA joystick" };
            var adapter = new ArrayAdapter<string>(this, Android.Resource.Layout.SimpleSpinnerItem, items);

            Spinner spinner = new Spinner(this);
            spinner.Adapter = adapter;
            spinner.SetSelection(global.JOY2());

            spinner.ItemSelected += (sender, e) =>
            {
                global.SetJOY2(e.Position);
                global.SaveSettings_();
            };

            mLinearLayout4.AddView(spinner);


            TextView t3 = new TextView(this);
            t3.SetTextColor(Color.Blue);
            t3.Text = "Sound";
            mLinearLayout4.AddView(t3);


            CheckBox checkBox2 = new CheckBox(this);
            checkBox2.Text = "Enable Sound";
            checkBox2.Checked = global.sound;
            checkBox2.CheckedChange += (sender, e) =>
            {
                global.sound = e.IsChecked;
            };

            mLinearLayout4.AddView(checkBox2);
            

            var items1 = new List<string>() { "ACB Stereo", "ABC Stereo", "Mono" };
            var adapter1 = new ArrayAdapter<string>(this, Android.Resource.Layout.SimpleSpinnerItem, items1);

            Spinner spinner1 = new Spinner(this);
            spinner1.Adapter = adapter1;
            spinner1.SetSelection(global.GetStereo());

            spinner1.ItemSelected += (sender, e) =>
            {
                global.SetStereo(e.Position);
                global.SaveSettings_();
            };

            mLinearLayout4.AddView(spinner1);



            TextView t4 = new TextView(this);
            t4.SetTextColor(Color.Blue);
            t4.Text = "Work directory";
            mLinearLayout4.AddView(t4);

            Diiir = new TextView(this);
            Diiir.Text = global.s;


            Button b4 = new Button(this);
            b4.Click += new EventHandler(SD);
            b4.Text = "Select directory containg files";

            Button b6 = new Button(this);
            b6.Click += new EventHandler(SDD);
            b6.Text = "Select " + FilesDir.ToString();

            mLinearLayout4.AddView(Diiir);
            mLinearLayout4.AddView(b4);
            mLinearLayout4.AddView(b6);


            TextView t5 = new TextView(this);
            t5.SetTextColor(Color.Blue);
            t5.Text = "Architecture";
            mLinearLayout4.AddView(t5);

            var items2 = new List<string>() { "ZX Spectrum 48k", "ZX Spectrum 128k", "Pentagon", "ZS-Scorpion" };
            var adapter2 = new ArrayAdapter<string>(this, Android.Resource.Layout.SimpleSpinnerItem, items2);

            spinner2 = new Spinner(this);
            spinner2.Adapter = adapter2;
            spinner2.SetSelection(global.GetMode2());

            spinner2.ItemSelected += (sender, e) =>
            {
                global.SetMode2(e.Position);
                global.SaveSettings_();
            };

            mLinearLayout4.AddView(spinner2);


            TextView t6 = new TextView(this);
            t6.SetTextColor(Color.Blue);
            t6.Text = "Disk B Image";
            mLinearLayout4.AddView(t6);

            Diiir1 = new TextView(this);
            Diiir1.Text = global.GetDiskB();

            Button b7 = new Button(this);
            b7.Click += new EventHandler(SD1);
            b7.Text = "Select Disk B Image";
   
            mLinearLayout4.AddView(Diiir1);
            mLinearLayout4.AddView(b7);



            Button b5 = new Button(this);
            b5.Click += new EventHandler(zurueck);
            b5.Text = "Back to emulator";
            mLinearLayout4.AddView(b5);



            //////////////////// LAYOUT 3 /////////////////////////////

            mLinearLayout3 = new LinearLayout(this);
            mLinearLayout3.Orientation = Orientation.Vertical;


            LinearLayout Layout3 = new LinearLayout(this);
            Layout3.Orientation = Orientation.Horizontal;

            e = new EditText(this);
            e.Hint = "HTTP(S)://URL";
            e.SetWidth(ScreenWidth * 3 / 4);
            Layout3.AddView(e);

            Button b3 = new Button(this);
            b3.Click += new EventHandler(go);
            b3.Text = "Go";
            Layout3.AddView(b3);

            mLinearLayout3.AddView(Layout3);


            TextView tw = new TextView(this);
            tw.Text = "files will be downloaded in background";

            mLinearLayout3.AddView(tw);


            AbsoluteLayout alayout = new AbsoluteLayout(this);

            wv = new WebView(this);
            wv.LoadUrl("http://www.sanarin.ru/glukalka/.Games/");
            wv.SetDownloadListener(new CustomDownloadListener());
            wv.SetWebViewClient(new HelloWebViewClient());

            WebSettings webSettings = wv.Settings;
            webSettings.JavaScriptEnabled = true;

            alayout.AddView(wv, ScreenWidth, ScreenHeight * 3 / 4);

            mLinearLayout3.AddView(alayout);

            Button b2 = new Button(this);
            b2.Click += new EventHandler(zurueck);
            b2.Text = "Back to emulator";
            mLinearLayout3.AddView(b2);

            //////////////////// LAYOUT 2 /////////////////////////////

            mLinearLayout2 = new LinearLayout(this);
            mLinearLayout2.Orientation = Orientation.Vertical;

            lw = new ListView(this);
            mLinearLayout2.AddView(lw);

            Button b1 = new Button(this);
            b1.Click += new EventHandler(zurueck);
            b1.Text = "Back to emulator";
            mLinearLayout2.AddView(b1);


            //////////////////// LAYOUT 21 /////////////////////////////

            mLinearLayout21 = new LinearLayout(this);
            mLinearLayout21.Orientation = Orientation.Vertical;

            lw1 = new ListView(this);
            mLinearLayout21.AddView(lw1);

            Button b11 = new Button(this);
            b11.Click += new EventHandler(zurueck1);
            b11.Text = "Back";
            mLinearLayout21.AddView(b11);


            //////////////////// LAYOUT 1 /////////////////////////////

            mLinearLayout1 = new LinearLayout(this);
            mLinearLayout1.Orientation = Orientation.Vertical;

            LinearLayout blayout = new LinearLayout(this);
            blayout.Orientation = Orientation.Horizontal;


            ImageButton bopen = new ImageButton(this);
            bopen.SetImageResource(Resource.Drawable.open);
            bopen.Click += new EventHandler(Button_Clicked);
            blayout.AddView(bopen);

            ImageButton bweb = new ImageButton(this);
            bweb.SetImageResource(Resource.Drawable.web);
            bweb.Click += new EventHandler(openweb);
            blayout.AddView(bweb);

            ImageButton bsave = new ImageButton(this);
            bsave.SetImageResource(Resource.Drawable.save);
            bsave.Click += new EventHandler(Save);
            blayout.AddView(bsave);

            bpause = new ImageButton(this);
            bpause.SetImageResource(Resource.Drawable.pause);
            bpause.Click += new EventHandler(p_ause);
            blayout.AddView(bpause);

            ImageButton brun = new ImageButton(this);
            brun.SetImageResource(Resource.Drawable.run);
            brun.Click += new EventHandler(run);
            blayout.AddView(brun);

            ImageButton bsettings = new ImageButton(this);
            bsettings.SetImageResource(Resource.Drawable.settings);
            bsettings.Click += new EventHandler(Settings);
            blayout.AddView(bsettings);


            ImageButton breset = new ImageButton(this);
            breset.SetImageResource(Resource.Drawable.reset);
            breset.Click += new EventHandler(reset);
            blayout.AddView(breset);


            ImageButton bdump_s = new ImageButton(this);
            bdump_s.SetImageResource(Resource.Drawable.dump_s);
            bdump_s.Click += new EventHandler(dump_s);
            blayout.AddView(bdump_s);


            ImageButton bnmi = new ImageButton(this);
            bnmi.SetImageResource(Resource.Drawable.disc);
            bnmi.Click += new EventHandler(NmI);
            blayout.AddView(bnmi);

            ImageButton bquestion = new ImageButton(this);
            bquestion.SetImageResource(Resource.Drawable.question);
            bquestion.Click += new EventHandler(about);
            blayout.AddView(bquestion);


            mLinearLayout1.AddView(blayout);


            AbsoluteLayout dlayout = new AbsoluteLayout(this);
            MyView i = new MyView(this);
            dlayout.AddView(i, ScreenWidth, ScreenWidth * 3 / 4);
            mLinearLayout1.AddView(dlayout);           


            LinearLayout blayout1 = new LinearLayout(this);
            blayout1.Orientation = Orientation.Horizontal;
            blayout1.SetGravity(GravityFlags.Right); 

            Button BREAK = new Button(this);
            BREAK.Text = "BREAK";
            BREAK.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                         BREAK.Pressed = true;
                    global.Key(10 * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        BREAK.Pressed = false;
                    global.Key(10 * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            blayout1.AddView(BREAK);



            Button EDIT = new Button(this);
            EDIT.Text = "EDIT";
            EDIT.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if(animatekeys == 1)
                        EDIT.Pressed = true;
                    global.Key(5 * 2);
                    global.Key('1' * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        EDIT.Pressed = false;
                    global.Key(5 * 2 + 1);
                    global.Key('1' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            blayout1.AddView(EDIT);


            Button CLOCK = new Button(this);
            CLOCK.Text = "CLOCK";
            CLOCK.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        CLOCK.Pressed = true;

                    global.Key(5 * 2);
                    global.Key('2' * 2);

                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        CLOCK.Pressed = false;

                    global.Key(5 * 2 + 1);
                    global.Key('2' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            blayout1.AddView(CLOCK);



            Button UNKNOWN = new Button(this);
            UNKNOWN.Text = "DOWN";
            UNKNOWN.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        UNKNOWN.Pressed = true;
                    global.Key(5 * 2);
                    global.Key('6' * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        UNKNOWN.Pressed = false;
                    global.Key(5 * 2 + 1);
                    global.Key('6' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            blayout1.AddView(UNKNOWN);


            Button KAVICHKI = new Button(this);
            KAVICHKI.Text = "\"";
            KAVICHKI.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KAVICHKI.Pressed = true;
                    global.Key(11 * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KAVICHKI.Pressed = false;
                    global.Key(11 * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            blayout1.AddView(KAVICHKI);


            mLinearLayout1.AddView(blayout1);






            LinearLayout blayout2 = new LinearLayout(this);
            blayout2.Orientation = Orientation.Horizontal;
            blayout2.SetGravity(GravityFlags.Right);

            Button EXTM = new Button(this);
            EXTM.Text = "EXTM";
            EXTM.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        EXTM.Pressed = true;
                    global.Key(9 * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        EXTM.Pressed = false;
                    global.Key(9 * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            blayout2.AddView(EXTM);

            Button KEY_0 = new Button(this);
            KEY_0.Text = "0";
            KEY_0.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KEY_0.Pressed = true;
                    global.Key('0' * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KEY_0.Pressed = false;
                    global.Key('0' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            blayout2.AddView(KEY_0);

            Button UP = new Button(this);
            UP.Text = "▲";
            UP.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        UP.Pressed = true;
                    global.Key(0);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        UP.Pressed = false;
                    global.Key(0 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            blayout2.AddView(UP);

            Button KEY_SPACE = new Button(this);
            KEY_SPACE.Text = " ";
            KEY_SPACE.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KEY_SPACE.Pressed = true;
                    global.Key(' ' * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KEY_SPACE.Pressed = false;
                    global.Key(' ' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            blayout2.AddView(KEY_SPACE);

            Button POINT = new Button(this);
            POINT.Text = ".";         
            POINT.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        POINT.Pressed = true;
                    global.Key(12 * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        POINT.Pressed = false;
                    global.Key(12 * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            blayout2.AddView(POINT);


            mLinearLayout1.AddView(blayout2);


            LinearLayout blayout3 = new LinearLayout(this);
            blayout3.Orientation = Orientation.Horizontal;
            blayout3.SetGravity(GravityFlags.Right);

            Button DELETE = new Button(this);
            DELETE.Text = "DELETE";
            DELETE.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        DELETE.Pressed = true;
                    global.Key(8 * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        DELETE.Pressed = false;
                    global.Key(8 * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            blayout3.AddView(DELETE);

            Button LEFT = new Button(this);
            LEFT.Text = "◀";
            LEFT.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        LEFT.Pressed = true;
                    global.Key(2 * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        LEFT.Pressed = false;
                    global.Key(2 * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            blayout3.AddView(LEFT);

            Button FIRE1 = new Button(this);
            FIRE1.Text = "◼";
            FIRE1.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        FIRE1.Pressed = true;
                    global.Key(4 * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        FIRE1.Pressed = false;
                    global.Key(4 * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            blayout3.AddView(FIRE1);

            Button RIGHT = new Button(this);
            RIGHT.Text = "▶";
            RIGHT.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        RIGHT.Pressed = true;
                    global.Key(3 * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        RIGHT.Pressed = false;
                    global.Key(3 * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            blayout3.AddView(RIGHT);

            Button COMA = new Button(this);
            COMA.Text = ",";
            COMA.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        COMA.Pressed = true;
                    global.Key(6 * 2);
                    global.Key('N' * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        COMA.Pressed = false;
                    global.Key(6 * 2 + 1);
                    global.Key('N' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            blayout3.AddView(COMA);

            mLinearLayout1.AddView(blayout3);


            LinearLayout blayout4 = new LinearLayout(this);
            blayout4.Orientation = Orientation.Horizontal;
            blayout4.SetGravity(GravityFlags.Right);


            Button FIRE2 = new Button(this);
            FIRE2.Text = "FIRE";
            FIRE2.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        FIRE2.Pressed = true;
                    global.Key(4 * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        FIRE2.Pressed = false;
                    global.Key(4 * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            blayout4.AddView(FIRE2);

            Button KEY_P = new Button(this);
            KEY_P.Text = "P";
            KEY_P.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KEY_P.Pressed = true;
                    global.Key('P' * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KEY_P.Pressed = false;
                    global.Key('P' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            blayout4.AddView(KEY_P);

            Button DOWN = new Button(this);
            DOWN.Text = "▼";
            DOWN.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        DOWN.Pressed = true;
                    global.Key(1 * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        DOWN.Pressed = false;
                    global.Key(1 * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            blayout4.AddView(DOWN);

            Button KEY_ENTER = new Button(this);
            KEY_ENTER.Text = "⏎";
            KEY_ENTER.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KEY_ENTER.Pressed = true;
                    global.Key(7 * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KEY_ENTER.Pressed = false;
                    global.Key(7 * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            blayout4.AddView(KEY_ENTER);

            Button STAR = new Button(this);
            STAR.Text = "*";
            STAR.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        STAR.Pressed = true;
                    global.Key(13 * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        STAR.Pressed = false;
                    global.Key(13 * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            blayout4.AddView(STAR);


            mLinearLayout1.AddView(blayout4);




            LayoutParams buttonparam = new LayoutParams(ScreenWidth / 9, ScreenWidth / 10 - 4);



            LinearLayout klayout1 = new LinearLayout(this);
            klayout1.Orientation = Orientation.Horizontal;

            Button KEY_1 = new Button(this);
            KEY_1.Text = "1";
            KEY_1.LayoutParameters = buttonparam;
            KEY_1.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KEY_1.Pressed = true;
                    global.Key('1' * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KEY_1.Pressed = false;
                    global.Key('1' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            klayout1.AddView(KEY_1);

            Button KEY_2 = new Button(this);
            KEY_2.Text = "2";
            KEY_2.LayoutParameters = buttonparam;
            KEY_2.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KEY_2.Pressed = true;
                    global.Key('2' * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KEY_2.Pressed = false;
                    global.Key('2' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            klayout1.AddView(KEY_2);

            Button KEY_3 = new Button(this);
            KEY_3.Text = "3";
            KEY_3.LayoutParameters = buttonparam;
            KEY_3.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KEY_3.Pressed = true;
                    global.Key('3' * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KEY_3.Pressed = false;
                    global.Key('3' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            klayout1.AddView(KEY_3);

            Button KEY_4 = new Button(this);
            KEY_4.Text = "4";
            KEY_4.LayoutParameters = buttonparam;
            KEY_4.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KEY_4.Pressed = true;
                    global.Key('4' * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KEY_4.Pressed = false;
                    global.Key('4' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            klayout1.AddView(KEY_4);

            Button KEY_5 = new Button(this);
            KEY_5.Text = "5";
            KEY_5.LayoutParameters = buttonparam;
            KEY_5.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KEY_5.Pressed = true;
                    global.Key('5' * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KEY_5.Pressed = false;
                    global.Key('5' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            klayout1.AddView(KEY_5);

            Button KEY_6 = new Button(this);
            KEY_6.Text = "6";
            KEY_6.LayoutParameters = buttonparam;
            KEY_6.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KEY_6.Pressed = true;
                    global.Key('6' * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KEY_6.Pressed = false;
                    global.Key('6' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            klayout1.AddView(KEY_6);

            Button KEY_7 = new Button(this);
            KEY_7.Text = "7";
            KEY_7.LayoutParameters = buttonparam;
            KEY_7.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KEY_7.Pressed = true;
                    global.Key('7' * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KEY_7.Pressed = false;
                    global.Key('7' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            klayout1.AddView(KEY_7);

            Button KEY_8 = new Button(this);
            KEY_8.Text = "8";
            KEY_8.LayoutParameters = buttonparam;
            KEY_8.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KEY_8.Pressed = true;
                    global.Key('8' * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KEY_8.Pressed = false;
                    global.Key('8' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            klayout1.AddView(KEY_8);

            Button KEY_9 = new Button(this);
            KEY_9.Text = "9";
            KEY_9.LayoutParameters = buttonparam;
            KEY_9.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KEY_9.Pressed = true;
                    global.Key('9' * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KEY_9.Pressed = false;
                    global.Key('9' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            klayout1.AddView(KEY_9);

            mLinearLayout1.AddView(klayout1);




            LinearLayout klayout2 = new LinearLayout(this);
            klayout1.Orientation = Orientation.Horizontal;

            Button KEY_Q = new Button(this);
            KEY_Q.Text = "Q";
            KEY_Q.LayoutParameters = buttonparam;
            KEY_Q.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KEY_Q.Pressed = true;
                    global.Key('Q' * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KEY_Q.Pressed = false;
                    global.Key('Q' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            klayout2.AddView(KEY_Q);

            Button KEY_W = new Button(this);
            KEY_W.Text = "W";
            KEY_W.LayoutParameters = buttonparam;
            KEY_W.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KEY_W.Pressed = true;
                    global.Key('W' * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KEY_W.Pressed = false;
                    global.Key('W' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            klayout2.AddView(KEY_W);

            Button KEY_E = new Button(this);
            KEY_E.Text = "E";
            KEY_E.LayoutParameters = buttonparam;
            KEY_E.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KEY_E.Pressed = true;
                    global.Key('E' * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KEY_E.Pressed = false;
                    global.Key('E' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            klayout2.AddView(KEY_E);

            Button KEY_R = new Button(this);
            KEY_R.Text = "R";
            KEY_R.LayoutParameters = buttonparam;
            KEY_R.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KEY_R.Pressed = true;
                    global.Key('R' * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KEY_R.Pressed = false;
                    global.Key('R' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            klayout2.AddView(KEY_R);

            Button KEY_T = new Button(this);
            KEY_T.Text = "T";
            KEY_T.LayoutParameters = buttonparam;
            KEY_T.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KEY_T.Pressed = true;
                    global.Key('T' * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KEY_T.Pressed = false;
                    global.Key('T' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            klayout2.AddView(KEY_T);

            Button KEY_Y = new Button(this);
            KEY_Y.Text = "Y";
            KEY_Y.LayoutParameters = buttonparam;
            KEY_Y.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KEY_Y.Pressed = true;
                    global.Key('Y' * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KEY_Y.Pressed = false;
                    global.Key('Y' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            klayout2.AddView(KEY_Y);

            Button KEY_U = new Button(this);
            KEY_U.Text = "U";
            KEY_U.LayoutParameters = buttonparam;
            KEY_U.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KEY_U.Pressed = true;
                    global.Key('U' * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KEY_U.Pressed = false;
                    global.Key('U' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            klayout2.AddView(KEY_U);

            Button KEY_I = new Button(this);
            KEY_I.Text = "I";
            KEY_I.LayoutParameters = buttonparam;
            KEY_I.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KEY_I.Pressed = true;
                    global.Key('I' * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KEY_I.Pressed = false;
                    global.Key('I' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            klayout2.AddView(KEY_I);

            Button KEY_O = new Button(this);
            KEY_O.Text = "O";
            KEY_O.LayoutParameters = buttonparam;
            KEY_O.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KEY_O.Pressed = true;
                    global.Key('O' * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KEY_O.Pressed = false;
                    global.Key('O' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            klayout2.AddView(KEY_O);

            mLinearLayout1.AddView(klayout2);



            LinearLayout klayout3 = new LinearLayout(this);
            klayout1.Orientation = Orientation.Horizontal;

            Button KEY_A = new Button(this);
            KEY_A.Text = "A";
            KEY_A.LayoutParameters = buttonparam;
            KEY_A.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KEY_A.Pressed = true;
                    global.Key('A' * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KEY_A.Pressed = false;
                    global.Key('A' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            klayout3.AddView(KEY_A);

            Button KEY_S = new Button(this);
            KEY_S.Text = "S";
            KEY_S.LayoutParameters = buttonparam;
            KEY_S.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KEY_S.Pressed = true;
                    global.Key('S' * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KEY_S.Pressed = false;
                    global.Key('S' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            klayout3.AddView(KEY_S);

            Button KEY_D = new Button(this);
            KEY_D.Text = "D";
            KEY_D.LayoutParameters = buttonparam;
            KEY_D.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KEY_D.Pressed = true;
                    global.Key('D' * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KEY_D.Pressed = false;
                    global.Key('D' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            klayout3.AddView(KEY_D);

            Button KEY_F = new Button(this);
            KEY_F.Text = "F";
            KEY_F.LayoutParameters = buttonparam;
            KEY_F.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KEY_F.Pressed = true;
                    global.Key('F' * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KEY_F.Pressed = false;
                    global.Key('F' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            klayout3.AddView(KEY_F);

            Button KEY_G = new Button(this);
            KEY_G.Text = "G";
            KEY_G.LayoutParameters = buttonparam;
            KEY_G.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KEY_G.Pressed = true;
                    global.Key('G' * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KEY_G.Pressed = false;
                    global.Key('G' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            klayout3.AddView(KEY_G);

            Button KEY_H = new Button(this);
            KEY_H.Text = "H";
            KEY_H.LayoutParameters = buttonparam;
            KEY_H.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KEY_H.Pressed = true;
                    global.Key('H' * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KEY_H.Pressed = false;
                    global.Key('H' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            klayout3.AddView(KEY_H);

            Button KEY_J = new Button(this);
            KEY_J.Text = "J";
            KEY_J.LayoutParameters = buttonparam;
            KEY_J.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KEY_J.Pressed = true;
                    global.Key('J' * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KEY_J.Pressed = false;
                    global.Key('J' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            klayout3.AddView(KEY_J);

            Button KEY_K = new Button(this);
            KEY_K.Text = "K";
            KEY_K.LayoutParameters = buttonparam;
            KEY_K.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KEY_K.Pressed = true;
                    global.Key('K' * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KEY_K.Pressed = false;
                    global.Key('K' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            klayout3.AddView(KEY_K);

            Button KEY_L = new Button(this);
            KEY_L.Text = "L";
            KEY_L.LayoutParameters = buttonparam;
            KEY_L.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KEY_L.Pressed = true;
                    global.Key('L' * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KEY_L.Pressed = false;
                    global.Key('L' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            klayout3.AddView(KEY_L);

            mLinearLayout1.AddView(klayout3);





            LinearLayout klayout4 = new LinearLayout(this);
            klayout1.Orientation = Orientation.Horizontal;

            Button KEY_CS = new Button(this);
            KEY_CS.Text = "C";
            KEY_CS.LayoutParameters = buttonparam;
            KEY_CS.SetTextColor(Color.Red);
            KEY_CS.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KEY_CS.Pressed = true;
                    global.Key(5 * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KEY_CS.Pressed = false;
                    global.Key(5 * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            klayout4.AddView(KEY_CS);

            Button KEY_Z = new Button(this);
            KEY_Z.Text = "Z";
            KEY_Z.LayoutParameters = buttonparam;
            KEY_Z.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KEY_Z.Pressed = true;
                    global.Key('Z' * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KEY_Z.Pressed = false;
                    global.Key('Z' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            klayout4.AddView(KEY_Z);

            Button KEY_X = new Button(this);
            KEY_X.Text = "X";
            KEY_X.LayoutParameters = buttonparam;
            KEY_X.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KEY_X.Pressed = true;
                    global.Key('X' * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KEY_X.Pressed = false;
                    global.Key('X' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            klayout4.AddView(KEY_X);

            Button KEY_C = new Button(this);
            KEY_C.Text = "C";
            KEY_C.LayoutParameters = buttonparam;
            KEY_C.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KEY_C.Pressed = true;
                    global.Key('C' * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KEY_C.Pressed = false;
                    global.Key('C' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            klayout4.AddView(KEY_C);

            Button KEY_V = new Button(this);
            KEY_V.Text = "V";
            KEY_V.LayoutParameters = buttonparam;
            KEY_V.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KEY_V.Pressed = true;
                    global.Key('V' * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KEY_V.Pressed = false;
                    global.Key('V' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            klayout4.AddView(KEY_V);

            Button KEY_B = new Button(this);
            KEY_B.Text = "B";
            KEY_B.LayoutParameters = buttonparam;
            KEY_B.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KEY_B.Pressed = true;
                    global.Key('B' * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KEY_B.Pressed = false;
                    global.Key('B' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            klayout4.AddView(KEY_B);

            Button KEY_N = new Button(this);
            KEY_N.Text = "N";
            KEY_N.LayoutParameters = buttonparam;
            KEY_N.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KEY_N.Pressed = true;
                    global.Key('N' * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KEY_N.Pressed = false;
                    global.Key('N' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            klayout4.AddView(KEY_N);

            Button KEY_M = new Button(this);
            KEY_M.Text = "M";
            KEY_M.LayoutParameters = buttonparam;
            KEY_M.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KEY_M.Pressed = true;
                    global.Key('M' * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KEY_M.Pressed = false;
                    global.Key('M' * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            klayout4.AddView(KEY_M);

            Button KEY_SS = new Button(this);
            KEY_SS.Text = "S";
            KEY_SS.LayoutParameters = buttonparam;
            KEY_SS.SetTextColor(Color.Red);
            KEY_SS.Touch += (s, e) =>
            {
                var handled = false;
                if (e.Event.Action == MotionEventActions.Down)
                {
                    if (animatekeys == 1)
                        KEY_SS.Pressed = true;
                    global.Key(6 * 2);
                    handled = true;
                }
                else if (e.Event.Action == MotionEventActions.Up)
                {
                    if (animatekeys == 1)
                        KEY_SS.Pressed = false;
                    global.Key(6 * 2 + 1);
                    handled = true;
                }

                e.Handled = handled;
            };
            klayout4.AddView(KEY_SS);



            mLinearLayout1.AddView(klayout4);

            SetContentView(mLinearLayout1);

            
            this.RequestPermissions(new String[] { Android.Manifest.Permission.ReadExternalStorage }, 0);
            this.RequestPermissions(new String[] { Android.Manifest.Permission.WriteExternalStorage }, 0);

            string subject = Intent.DataString;

            if (subject != null)
            {
                string subj = Intent.Data.Path;

 

                FileInfo f = new FileInfo(subj);

                global.current_file = f.Name.Split(".")[0];

                global.b = System.Text.Encoding.UTF8.GetBytes(subj);
                global.FOPENFP();

                /*
                Toast.MakeText(this, subj,
                         Android.Widget.ToastLength.Short).Show();
                */
            }

           

        }


       
    }
}