﻿# define errors (-1)
# define no_errors 0


#include "emulate1.h"

# include "emulate.h"
# include "android_io.h"

#include <stdio.h>

unsigned int videomemory1[640 * 480];
char HOMEDIR[200];

#define LOGI(...) ((void)__android_log_print(ANDROID_LOG_INFO, "emulate1", __VA_ARGS__))
#define LOGW(...) ((void)__android_log_print(ANDROID_LOG_WARN, "emulate1", __VA_ARGS__))



extern "C" {
	/* Эта тривиальная функция возвращает ABI платформы, для которой скомпилирована эта динамическая библиотека с машинным кодом.*/
	const char* emulate1::getPlatformABI()
	{
#if defined(__arm__)
#if defined(__ARM_ARCH_7A__)
#if defined(__ARM_NEON__)
#define ABI "armeabi-v7a/NEON"
#else
#define ABI "armeabi-v7a"
#endif
#else
#define ABI "armeabi"
#endif
#elif defined(__i386__)
#define ABI "x86"
#else
#define ABI "unknown"
#endif
		LOGI("This dynamic shared library is compiled with ABI: %s", ABI);
		return "This native library is compiled with ABI: %s" ABI ".";
	}

	void init(void)
	{
		SetHomeDir(HOMEDIR);
		
		if (init(reinterpret_cast<unsigned char*>(videomemory1)) == errors)
		{
			LOGI((char*)"Fatal error, can't continue");
		}
	}


	void F_open(void)
	{
		open_file(GetHomeDer(), HOMEDIR);
	}

	void  key(int filename)
	{
		joystick(filename / 2, filename % 2);
	}

	void step(void)
	{
		timerfunc();
	}

	unsigned int * Get_VM(void)
	{
		return (videomemory1);
	}

	char * Get_FN(void)
	{
		return (HOMEDIR);
	}

	char * Get_SB(void)
	{
		return ((char *)GetSoundBuffer());
	}

	char Border(void)
	{
		return (GetBorder());
	}

	void save(void)
	{
		SaveZ80(HOMEDIR, GetHomeDer());
	}

	void reset(void)
	{
		reset_h();
	}

	int GetTapeTraps(void)
	{
		//LOGI("GetTT\n");
		return TT();
	}

	void SetTapeTraps(int tt)
	{
		//LOGI("SetTapeTraps %d\n", tt);
		STT(tt);
	}

	void SaveSettings(void)
	{
		//LOGI("save\n");
		SaveIniFile();
	}


	int GetJOY1(void)
	{
		//LOGI("GetJOY1\n");
		return GetJOY();
	}

	void SetJOY1(int type)
	{
		//LOGI("JOY%d\n", type);
		SetJOY(type);
	}

	int GetMode1()
	{
		char * m = (GetMode());

		if (!strcmp(m, "48")) return 0;
		if (!strcmp(m, "128")) return 1;
		if (!strcmp(m, "Pentagon")) return 2;
		if (!strcmp(m, "Scorpion")) return 3;
	}

	void SetMode1(int mode)
	{
		if (mode == 0) SetMode("48");
		if (mode == 1) SetMode("128");
		if (mode == 2) SetMode("Pentagon");
		if (mode == 3) SetMode("Scorpion");
	}

	int Get_stereo(void)
	{
		unsigned char * sm = GetSM();
		return (*sm);
	}

	void Set_stereo(int arg)
	{
		unsigned char* sm = GetSM();
		(*sm) = arg;
	}

	int Gett (void)
	{
		return (*GetSQT());
	}

	void sethomedir(void)
	{
		SetHomeDer(HOMEDIR);
	}

	char * gethomedir(void)
	{
		return GetHomeDer();
	}

	void DumpPSG1(int begin)
	{
		DumpPSG(HOMEDIR, GetHomeDer(), begin);
	}


	char * GetDisk(int n)
	{
		return  (GetDisk1(n));
	}

	void SetDisk(int n)
	{
		char ext[4];
	
		sprintf(ext, "%s", &HOMEDIR[strlen(HOMEDIR) - 3]);

		if (io_strcasecmp(ext, "TRD") == 0)
		{
			SelectTRDFile(n, HOMEDIR, GetHomeDer());
		}

		if (io_strcasecmp(ext, "FDI") == 0)
		{
			SelectFDIFile(n, HOMEDIR, GetHomeDer());
		}
	}


	void F_open_full(void)
	{
		char string[400];

		if (!io_strncasecmp(HOMEDIR, "/root", 5))
		{
			strcpy(string, &HOMEDIR[5]);
			open_file(0, string);
		}
	}

	void NMI(void)
	{
		GenerateNMI();
	}

	void emulate1()
	{
	}

	emulate1::emulate1()
	{
	}

	emulate1::~emulate1()
	{
	}
}
