
typedef struct                                                                                
{                                                                                             
	unsigned d0 : 1;                                                                      
	unsigned d1 : 1;                                                                      
	unsigned d2 : 1;                                                                      
	unsigned d3 : 1;                                                                      
	unsigned d4 : 1;                                                                      
	unsigned u1 : 1;                                                                      
	unsigned tape : 1;                                                                    
	unsigned u2 : 1;                                                                      

} KeybPortType;   

typedef struct                                                                                
{                                                                                             
	unsigned right  : 1;                                                                  
	unsigned left   : 1;                                                                  
	unsigned down   : 1;                                                                  
	unsigned up     : 1;                                                                  
	unsigned fire   : 1;                                                                  
	unsigned unused : 3;                                                                  
} KepmstonType;     

typedef union 
{
	unsigned char byte;
	KepmstonType bit;
} kempston_type;

int init (unsigned char *);
void GetWH(int*, int*);
void timerfunc(void);
int * getVM(void);

void FillKeybp( KeybPortType **pf7fe, KeybPortType  **pfbfe, KeybPortType  **pfdfe, KeybPortType  **pfefe, KeybPortType  **peffe, 
			   KeybPortType **pdffe, KeybPortType  **pbffe, KeybPortType  **psffe, kempston_type **k, int ** t);

char * ImagesDir();
void open_file(char *, char *);

void reset_h(void);

void SaveZ80(char * path, char * dir);

int GetScan();
void SetScan(int arg);
char * GetMode();
void * GetSoundBuffer(void);

unsigned long long GetCurrentTime1(void);

char * Get_audio_name(void);

void play(char * buffer, int len);
int init_card(char * audio_fil_name);
void DumpPSG(char * filename, char * dir, int begin);

unsigned char * GetSM();
unsigned int * GetBV();

void Zamolchi(void);

int * GetTT();
int * GetSQT();
int * Get_LP();

void joystick(int action, int up);

void SetHomeDir(char* arg);
char GetBorder(void);
void SaveIniFile(void);

int TT(void);
void STT(int rrr);

int GetJOY(void);
void SetJOY(int type);
char * GetMode();
void SetMode(char * aaa);
char * GetHomeDer(void);
void SetHomeDer(char * arg);

char* GetDisk1(int n);
void SelectFDIFile(int num, char* filename, char* dir);
void SelectTRDFile(int num, char* filename, char* dir);

unsigned char kmGetKeys(void);
unsigned char kmGetY (void);
unsigned char kmGetX (void);
int * GetSP();
int * Get_opengl();
int * Get_aspect();
int * GetKM(void);
int * Get_slow();
const char ** Get_ss();
void SetSS(char * arg);

void SetDisk(char * HOMEDIR, int n);
void GenerateNMI(void);