# define errors (-1)
# define no_errors 0


# include <fcntl.h>
# include <stdio.h>
# include <unistd.h>
# include <sys/ioctl.h>
# include <sys/soundcard.h>

# include <stdlib.h>
# include <string.h>

# include <linux/joystick.h>

# include "emulate.h"

int audio_fil = -1;

void play(char * buffer, int len)
{
    if (audio_fil != -1)
	write(audio_fil, buffer, len);
}

int init_card(char * audio_fil_name)
{
#define BASE_SOUND_FRAG_PWR	6

	int tmp;

	int samplesize = 16;
	int dsp_speed = 44100; 
	int dsp_stereo = 1;

	int frag;


	audio_fil = open (audio_fil_name, O_WRONLY, 0);                                                       

	if (audio_fil == -1)                                                                                
	{                                                                                             
		printf("Unable open %s for writing. SoundcardInit failed.\n",audio_fil_name);
		perror (audio_fil_name);
		return(errors);
	}  


	tmp=AFMT_S16_LE;
	if((ioctl(audio_fil,SNDCTL_DSP_SETFMT,&tmp))==-1)
	{
		perror("SNDCTL_DSP_SETFMT");
		close(audio_fil);

		return(errors);
	}

	tmp = samplesize;                                                                               
	ioctl(audio_fil, SNDCTL_DSP_SAMPLESIZE, &samplesize);                                               
	if (tmp != samplesize)                                                                          
	{                                                                                               
		printf("Unable set samplesize = %d. SoundcardInit failed.\n", tmp);
		perror("SNDCTL_DSP_SAMPLESIZE");                                                                    
		close(audio_fil);
		return(errors);                                                                                  
	}                                                                                               

	if (ioctl (audio_fil, SNDCTL_DSP_STEREO, &dsp_stereo)==-1)                                          
	{                                                                                               
		printf ("Unable to set stereo. SoundcardInit failed.\n");                               
		perror (audio_fil_name);                                                                        
		close(audio_fil);
		return(errors);                                                                                      
	}                                                                                               

	if (ioctl (audio_fil, SNDCTL_DSP_SPEED, &dsp_speed) == -1)                                          
	{                                                                                             
		printf ("Unable to set audio_fil speed = %d. SoundcardInit failed.\n",dsp_speed);                               
		perror (audio_fil_name);                                                                        
		close(audio_fil);
		return(errors);                                                                                  
	}        


	frag=(0x80000|BASE_SOUND_FRAG_PWR);

	if(dsp_speed>8000) frag++;
	if(dsp_speed>16000) frag++;
	if(dsp_speed>32000) frag++;
	if(samplesize>8) frag++;
	if(dsp_stereo>0) frag++;

	if(ioctl(audio_fil,SNDCTL_DSP_SETFRAGMENT,&frag)<0)
	{
		perror ("SNDCTL_DSP_SETFRAGMENT");
		close(audio_fil);
		return(errors);
	}

	return(no_errors);
}

char Joy(void)
{
    static int first = 1;
    static int fd;
    char rv;
    
    if (first)
    {
	first = 0;
	fd = open ("/dev/input/js0", O_RDONLY);
    }

    if (fd==-1)
	return -1;

    struct JS_DATA_TYPE js;
    
    if (read (fd, &js, JS_RETURN) != JS_RETURN) 
    {
	return -1;
    }
    
    rv = 0;
    
                if (js.x<64)
                        rv |= 1;

                if (js.x>(128+64))
                        rv |= 2;
                
                if (js.y<65)
                        rv |= 8;
        
                if (js.y>(128+64))
                        rv |= 4;

                if (js.buttons)
                        rv |= 16;

    
    return rv;
}

# define MAXCARDS 20
char *** cardslist;

char *** cards_list(void)
{

	if (cardslist) free(cardslist);

	cardslist = (char ***) malloc(MAXCARDS * sizeof (char **));

	for (int i=0; i<MAXCARDS; i++)
		cardslist[i]= (char**) malloc (2 * sizeof (char *));	
	
	for (int i=0; i<MAXCARDS; i++)
	{
		for (int j=0; j<2; j++)
		{
			cardslist[i][j]= (char*) malloc (101 * sizeof (char));
			memset(cardslist[i][j], 0, 100);
		}
	}

    sprintf (cardslist[0][0], "/dev/dsp");
    sprintf (cardslist[0][1], "/dev/dsp");

    sprintf (cardslist[1][0], "/dev/dsp0");
    sprintf (cardslist[1][1], "/dev/dsp0");

    sprintf (cardslist[2][0], "/dev/dsp1");
    sprintf (cardslist[2][1], "/dev/dsp1");

    sprintf (cardslist[3][0], "/dev/dsp2");
    sprintf (cardslist[3][1], "/dev/dsp2");

    sprintf (cardslist[4][0], "/dev/dsp3");
    sprintf (cardslist[4][1], "/dev/dsp3");

    sprintf (cardslist[5][0], "/dev/dsp4");
    sprintf (cardslist[5][1], "/dev/dsp4");

    return (cardslist);
}